; LCDBED

.text
.include "allgdef.inc"
.global	Lcdbed

; 1. Teil = Text 
; Eingang: D)lcdpuffer = Ascii-Daten, 0x0 als Endezeichen
; 		(D)lcdsta = 0
;		(D)lcdzgr= zeiger auf lcdpuffer
;		(D)schriftfarbe, (D)hintergrund
;		(D)xpos, (D)ypos = Char unten rechts
;		(D)schriftgroessse
;		(D)nachunten, (D)nachrechts = um n Pixel verschieben
;		(B)lcdaktiv = 1

; 2.Teil = Linie bzw mit Schriftfarbe gefllte Flche zeichnen
; Eingang: lcdsta = 3

Lcdbed:
	btss	merker,#lcdaktiv
	return
	mov		lcdsta,w0
	bra		w0

	bra		lcdbed0
	bra		lcdbed1
	bra		lcdbed2
	bra		lcdbed3
	
; Fester setzen
lcdbed0:
	call	Setzefenster
	inc		lcdsta
	return
	
; ein Char komplett zum LCD senden 
lcdbed1:
	call	Charzumtft
	inc	lcdsta
	return
	
; prfen ob alle char im LCD sind
lcdbed2:
	clr		lcdsta
	inc2	lcdzgr
	mov		lcdzgr,w0
	cp0		[w0]      		; Endezeichen?
	bra		z,lcdbed2a      ; ja
 	return
lcdbed2a:
 	bclr	merker,#lcdaktiv	; beenden
 	return

; Eine Linie bzw Flche zeichnen
lcdbed3:
	call	ZeichneLinie	
	clr		lcdsta
 	bclr	merker,#lcdaktiv	; beenden
 	return
	
; ======================== UPs ==============================
	 		
; ------------------------------------------------
; 1 Char komplett ins bereits gesetzte Fenster schreiben
; Eingang: Ascii-String in (D)lcdpuffer, Zeiger darauf in (D)lcdzgr
; Farbe ist in (D)schriftfarbe und (D)hintergrund
; Schrift in (D)schriftgroesse (1 oder 2)
; (D)fonthoehe, (D)fontbreite, (D)fontadresse, (D)minifont
; ------------------------------------------------

Charzumtft:
	mov		#0x2c,w1
	call	Commandozumtft
	mov		schriftgroesse,w7
	dec		w7,w7				; zum Toggeln / Wiederholen
	clr		w6					; W6 = Reihenzhler
	mov		lcdzgr,w0           ; Zeiger auf ASCII
	mov		[w0],w1  			; char ascii holen nach W1
	mov		fontadresse,w5   	; W5 = Zeiger auf Pixel-Reihe
	mov		adressenoffset,w4	; 32, 52
	mul.uu	w1,w4,w2           	; W0 x doppelte pixelhoehe = W2,W3 W2=NW
	add		w5,w2,w5       		; W5 = Zeiger auf 1. Font-Word

charzumtft1:	
	do		w7,charzumtft1a
	call	Pixelhorizontal
charzumtft1a:
 	nop
 	inc2	w5,w5				; nchstes Fontbyte
	inc		w6,w6				; Bytezhler
	mov		adressenoffset,w1
	cp		w6,w1
	bra		nz,charzumtft1
	bset	LATA,#lcd_cs 	; ende
	return

; schreibt eine 16bit-Reihe zum TFT-Fenster
; Eingang: schriftgroesse (-faktor 0 oder 2) in w7, Font-Byte-Adr in W5, 
; pixelbreite (16 od 12), minifont auf 0 wenn 16x26, auf 4 wenn 12x16
Pixelhorizontal:
	mov		bitzaehler,w4				; W4 = Rotierzhler
	mov		[w5],w2
	cp0		minifont
	bra		z,pixelh1
	mov		minifont,w1	
	repeat	w1
	rrc		w2,w2           ; Pixelbyte rotieren
pixelh1: 
 	btsc	w2,#0				; b0 = 1?
	bra		pixelh3
; hintergrundfarbe senden
	do		w7,pixelh2
	mov		hintergrund,w1
	and		#0x00ff,w1
	call	Datenzumtft
	mov		hintergrund,w1
	swap	w1
	and		#0x00ff,w1
	call	Datenzumtft
pixelh2:
 	nop
	bra		pixelh5
; Schriftfarbe senden	
pixelh3:
 	do		w7,pixelh4
	mov		schriftfarbe,w1
	and		#0x00ff,w1
	call	Datenzumtft
	mov		schriftfarbe,w1
	swap	w1
	and		#0x00ff,w1
	call	Datenzumtft
pixelh4:
	nop
; Rotieren
pixelh5:
	rrc		w2,w2           ; Pixelbyte rotieren
	dec		w4,w4			; Rotierzhler
	bra		nz,pixelh1		; nchstes Bit
	return

; ---------------------------------------------
; Sendet die 4 Fensteradressen zum TFT, xy-Position = 0,0 ist oben links
; Eingang: (D)xpos, (D)ypos Position oben links fr ein Char auf TFT
; werden anschliessend fr folgenden Char erhht und D)nachunten, (D)nachrechts
; werden auf Position addiert wenn Abstand zum folgenden Char soll.
; ---------------------------------------------
Setzefenster:
	
; SC, EC Pixelreihe senkrecht von unten nach oben
	mov		#0x2b,w1
	call	Commandozumtft
	mov		ypos,w3
	swap	w3
	ze		w3,w1			; SC, oben HW
	call	Datenzumtft
	swap	w3
	ze		w3,w1
	call	Datenzumtft 	; SC, oben NW
	mov		fonthoehe,w2
	dec		w2,w2
	mov		ypos,w3
	add		w3,w2,w3
	swap	w3
	ze		w3,w1
	call	Datenzumtft		; EC, unten HW
	swap	w3
	ze		w3,w1
	call	Datenzumtft     ; EC, unten MW
	bset	LATA,#lcd_cs 	; commando  ende 
		
; Sp, EP Pixelreihe von links nach rechts
	mov		#0x2a,w1
	call	Commandozumtft
	mov		xpos,w3
	swap	w3
	ze		w3,w1			; SP, links HW
	call	Datenzumtft
	swap	w3
	ze		w3,w1
	call	Datenzumtft 	; SP, links NW
	mov		fontbreite,w2
	dec		w2,w2
	mov		xpos,w3
	add		w3,w2,w3
	swap	w3  
	ze		w3,w1
	call	Datenzumtft		; EP, rechts HW
	swap	w3
	ze		w3,w1
	call	Datenzumtft     ; EP, rechts NW
	bset	LATA,#lcd_cs 	; commando  ende

; nchste X-Position
	mov		nachrechts,w6
	mov		fontbreite,w5
	mov		xpos,w4
	add		w4,w6,w4		; xfont + fontbreite
	add		w4,w5,w4		; + nachrechts
	mov		#479,w1
	cp		w1,w4			; Zeile am Ende?
	bra		le,setzefenster2
	mov		w4,xpos			; folgende xpos in der selben Zeilen
	return
; folgende x-y-Psoition wenn vorige Zeile nichts frei ist
setzefenster2:
	clr		xpos
	mov		ypos,w1
	mov		fonthoehe,w2
	mov		nachunten,w3
	add		w1,w2,w1		; 
	add		w1,w3,w1
	mov		w1,ypos
	return

; ********************************************************************

; --------------------------------------------------------------------
; ZeichneLinie zeichnet eine Linie bzw eine mit Hintergrundfarbe gefllte Flche
; Parameter: X Y links oben, X * Y = darf nicht ber 65000 sein!
; (D)ypos = oben, (D)xpos = links, (D)linienhoehe, (D)linienbreite
; ---------------------------------------------------------------------

ZeichneLinie:
; SC, EC Pixelreihe senkrecht von oben nach unten
	mov		#0x2b,w1
	call	Commandozumtft
	mov		ypos,w3
	swap	w3
	ze		w3,w1			; SC, oben HW
	call	Datenzumtft
	swap	w3
	ze		w3,w1
	call	Datenzumtft 	; SC, oben NW
	mov		linienhoehe,w2
	dec		w2,w2
	mov		ypos,w3
	add		w3,w2,w3
	swap	w3
	ze		w3,w1
	call	Datenzumtft		; EC, unten HW
	swap	w3
	ze		w3,w1
	call	Datenzumtft     ; EC, unten MW
	bset	LATA,#lcd_cs 	; commando  ende
	 
; Sp, EP Pixelreihe von links nach rechts
	mov		#0x2a,w1
	call	Commandozumtft
	mov		xpos,w3
	swap	w3
	ze		w3,w1			; SP, links HW
	call	Datenzumtft
	swap	w3
	ze		w3,w1
	call	Datenzumtft 	; SP, links NW
	mov		linienbreite,w2
	dec		w2,w2
	mov		xpos,w3
	add		w3,w2,w3
	swap	w3  
	ze		w3,w1
	call	Datenzumtft		; EP, rechts HW
	swap	w3
	ze		w3,w1
	call	Datenzumtft     ; EP, rechts NW
	bset	LATA,#lcd_cs 	; commando  ende
	
; Fenster mit (D)hintergrund fllen
	mov		#0x2c,w1
	call	Commandozumtft
	mov		linienbreite,w0
	mov		linienhoehe,w1
	mul.uu	w0,w1,w2		; w0 x w1 = w3,w2
	nop
zeichnel1:
	mov		hintergrund,w1
	and		#0x00ff,w1
	call	Datenzumtft
	mov		hintergrund,w1
	swap	w1
	and		#0x00ff,w1
	call	Datenzumtft
    dec     w2,w2
    bra     nz,zeichnel1
	nop
	nop
	nop
 	bset	LATA,#lcd_cs 	; ende
	return
	
			
 


		
	
	
	